<?php
    /**
    *
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class VisualizzatoreModuloLoginRegistrati extends VisualizzatoreComponente {
        private $configurazioneAspetto;
        private $impostazioni;
        private $datiModuloRegistrazione;
        private $gestoreTraduzioni;
        private $linguaCorrente;
        
        function __construct($db) {
            parent::__construct($db);
            $this->datiModuloRegistrazione = $db->leggiSingolaRiga("geecAd_moduliRegistrazione",1);
        }
        
        function generaContenutoSezione($dati) {
            $impostazioni = parent::getDb()->leggiSingolaRiga("geecAd_impostazioni",1);
            
            ?>
            <div id="" class="container d-flex">
                <div class="card card-body box-shadow-lite fadeInDown text-left">
                    <div class="row">
                        <div class="col-10 col-sm-8 col-md-4 mx-auto">
                            <a href="index.php">
                                <img class="img-fluid mb-4" src="<?php echo $this->configurazioneAspetto["logo"]; ?>" />
                            </a>
                        </div>

                        <div class="w-100"></div>
                        
                        <div class="col-md-6">
                            <?php 
                                if(isset($_GET["status"])) {
                                    if($_GET["status"]==400) {
                                        echo"<p class=\"alert alert-danger\">Errore: email o password errati</p>";
                                    }
                                    else if($_GET["status"]==410) {
                                        echo"<p class=\"alert alert-danger\">Errore: il tuo account non è attivo!</p>";
                                    }
                                    else if($_GET["status"]==300) {
                                        echo"<p class=\"alert alert-warning\">Questa email è già presente, hai perso la password?</p>";
                                    }
                                    else if($_GET["status"]==200) {
                                        echo"<p class=\"alert alert-success\">Registrazione avvenuta, a presto :)</p>";
                                    }
                                }
                                if($this->impostazioni["disattivaAccessoUtenti"]=="si") {
                                    echo"<p class=\"alert alert-warning\">{$this->impostazioni["messaggioAccessoDisattivato"]}</p>";
                                } 
                            ?>
                            <div class="mb-2"><?php echo $this->impostazioni["titoloAreaLogin"]; ?></div>
                            <form name="formLogin" action="utenti/login.php" method="post">
                                <div class="form-group">
                                    <input type="email" name="email" id="inputEmail" class="form-control" placeholder="Indirizzo email" required autofocus>
                                </div>
                                <div class="form-group">
                                    <input type="password" name="password" id="password" class="form-control" required />
                                </div>

                                <input type="text" class="d-none" name="tokenSicurezza" <?php echo"value=\"{$_SESSION["tokenSicurezza"]}\""; ?> >

                                <?php
                                    if($this->impostazioni["disattivaAccessoUtenti"]!="si") {
                                ?>
                                        <div class="custom-control custom-checkbox mb-3">
                                            <input type="checkbox" class="custom-control-input" id="customCheck1">
                                            <label class="custom-control-label" for="customCheck1">Ricordati di me</label>
                                        </div>
                                        <button class="btn btn-primary btn-block" type="submit" onclick="document.formLogin.submit()">Login</button>
                                <?php 
                                        if($this->impostazioni["accessoFacebook"]=="si") {
                                            include "include/facebookSdk.php";
                                ?>

                                            <fb:login-button scope="public_profile,email" onlogin="checkLoginState();">
                                            </fb:login-button>

                                            <div id="status">
                                            </div>
                                <?php 
                                        }

                                        if($this->impostazioni["registrazioneUtenti"]=="si") {
                                           $paginaRegistrazione     = parent::getDb()->leggiSingolaRiga("geecAd_contenuti",$this->impostazioni["paginaRegistrazione"]);
                                           $linkPaginaRegistrazione = GeneratoreUrl::creaUrlContenuto($paginaRegistrazione, $this->impostazioni["ottimizzazioneUrl"], $this->impostazioni["urlPiattaforma"]);
                                ?>
                                       <a href="<?php echo $linkPaginaRegistrazione ?>" class="btn btn-outline-primary btn-block" >Registrati</a>
                                <?php
                                        }

                                        $paginaRecuperoPassword     = parent::getDb()->leggiSingolaRiga("geecAd_contenuti",$this->impostazioni["paginaRecuperoPassword"]);
                                        $linkPaginaRecuperoPassword = GeneratoreUrl::creaUrlContenuto($paginaRecuperoPassword, $this->impostazioni["ottimizzazioneUrl"], $this->impostazioni["urlPiattaforma"]);
                                ?>
                                        <a class="mt-2 d-block" href="<?php echo $linkPaginaRecuperoPassword ?>">Password dimenticata?</a>
                                <?php 
                                    }
                                ?>
                            </form>                                    
                        </div>

                        <div class="col-md-6">
                            <?php 
                                if(isset($_GET["status"])) {
                                    if($_GET["status"]==400) {
                                        echo"<p class=\"alert alert-danger\">Errore: questa mail è già presente nel database</p>";
                                    }
                                }

                                if($impostazioni["registrazioneUtenti"]!="si") {
                                    echo"<p class=\"alert alert-warning\">La registrazione degli utenti è disabilitata</p>";
                                }
                                else {
                             ?>

                                <form name="formRegistrazione" action=utenti/eseguiRegistrazione.php method="post">
                                <?php
                                    if($this->datiModuloRegistrazione["richiediNome"]=="si") {
                                ?>
                                    <div class="form-group">
                                        <input type="text" class="form-control" id="exampleInputText1" name="nome" placeholder="Nome">
                                    </div>
                                <?php
                                    }
                                    if($this->datiModuloRegistrazione["richiediCognome"]=="si") {
                                ?>
                                  <div class="form-group">
                                    <input type="text" class="form-control" id="exampleInputText1" name="cognome" placeholder="Cognome">
                                 </div>
                                <?php
                                    }
                                    if($this->datiModuloRegistrazione["richiediCitta"]=="si") {
                                ?>
                                  <div class="form-group">
                                    <input type="text" class="form-control" id="exampleInputText1" name="citta" placeholder="Città">
                                 </div>
                                <?php
                                    }
                                    if($this->datiModuloRegistrazione["richiediTelefono"]=="si") {
                                ?>
                                  <div class="form-group">
                                    <input type="text" class="form-control" id="exampleInputText1" name="richiediTelefono" placeholder="Telefono">
                                 </div>
                                <?php
                                    }
                                    if($this->datiModuloRegistrazione["richiediEmail"]=="si") {
                                ?>
                                  <div class="form-group">
                                    <input type="email" class="form-control" id="exampleInputEmail1" name="email" placeholder="Email">
                                  </div>
                                <?php
                                    }
                                    if($this->datiModuloRegistrazione["richiediPassword"]=="si") {
                                ?>
                                  <div class="form-group">
                                        <input type="password" class="form-control " name="password" id="exampleInputPassword1" placeholder="Password">
                                  </div>
                                <?php
                                    }
                                    if($this->datiModuloRegistrazione["richiediGruppo"]=="si") {
                                        $queryGruppi = "SELECT * FROM geec_gruppi";
                                        $risGruppi = parent::getDb()->eseguiQueryLettura($queryGruppi);
                                ?>
                                    <div class="form-group">
                                        <p>Seleziona il gruppo di appartenzenza</p>

                                        <select name=gruppo class="form-control" >
                                        <?php 
                                            if($this->datiModuloRegistrazione["gruppoObbligatorio"]!="si") {
                                                ?><option value=0>Nessun gruppo</option><?php
                                            }

                                            while($gruppo = $risGruppi->fetch_assoc()) {
                                                echo"<option value={$gruppo["id"]}>{$gruppo["nome"]}</option>";
                                            }
                                        ?>
                                        </select>
                                    </div>
                                <?php
                                        }
                                ?>

                                  <button type="submit" class="btn btn-primary btn-block" onclick="document.formRegistrazione.submit()">Registrati</button>
                                    <?php
                                        if($this->impostazioni["accessoFacebook"]=="si") {
                                            include "include/facebookSdk.php";
                                    ?>
                                            <fb:login-button scope="public_profile,email" onlogin="checkLoginState();">
                                            </fb:login-button>
                                            <br><br>
                                    <?php 
                                        }

                                        $paginaLogin     = parent::getDb()->leggiSingolaRiga("geecAd_contenuti",$this->impostazioni["paginaLogin"]);
                                        $linkPaginaLogin = GeneratoreUrl::creaUrlContenuto($paginaLogin, $this->impostazioni["ottimizzazioneUrl"], $this->impostazioni["urlPiattaforma"]);
                                        echo"<div class=\"mt-2\"><a href=\"$linkPaginaLogin\">Hai già un account?</a></div>";
                                    }
                                ?>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <?php
        }
        
        // getter & setter
        public function getConfigurazioneAspetto() {
            return $this->configurazioneAspetto;
        }

        public function getImpostazioni() {
            return $this->impostazioni;
        }

        public function setConfigurazioneAspetto($configurazioneAspetto) {
            $this->configurazioneAspetto = $configurazioneAspetto;
        }

        public function setImpostazioni($impostazioni) {
            $this->impostazioni = $impostazioni;
        }

        public function getGestoreTraduzioni() {
            return $this->gestoreTraduzioni;
        }

        public function getLinguaCorrente() {
            return $this->linguaCorrente;
        }

        public function setGestoreTraduzioni($gestoreTraduzioni): void {
            $this->gestoreTraduzioni = $gestoreTraduzioni;
        }

        public function setLinguaCorrente($linguaCorrente): void {
            $this->linguaCorrente = $linguaCorrente;
        }

    }